/*--------------------------------------------------------*/
/*
 File:	xor.cpp

 Client App for xor function - learning and running
 © Christophe Morvant - QuBernan Project

*/
/*--------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include<iostream.h>


#ifndef XOR_H
#include "xor.h"
#endif
#ifndef _LIST_H
#include <List.h>
#endif
#ifndef _APPLICATION_H
#include <Application.h>
#endif
#ifndef _MESSENGER_H
#include <Messenger.h>
#endif
/*--------------------------------------------------------*/
enum {


	LESSON			= 'less', // What BMessage for learning process
	THINKNOW		= 'thin', // What BMessage for running process
	LEARN_RESULT    = 'leok', // What BMessage [received] sent by server when learning process is OK
	BRAINBOX_ERR	= 'boko', // What BMessage [received] Errors occured in server
	THINK_RESULT	= 'thok', // What BMessage [received] sent by server when running process is OK
	RESULTAT        = 'rslt'  // What BMessage : reply
};


/*--------------------------------------------------------*/




main(int argc, char* argv[])

{


	ClientrunApp* Application = new ClientrunApp();

	Application->Run();


	delete Application;
	return 0;
}


/*--------------------------------------------------------*/


ClientrunApp::ClientrunApp()
	: BApplication("application/x-vnd.Braininabox-ClientXor")
{
}

void ClientrunApp::MessageReceived(BMessage *mess)

{



	char *Texte;
	switch (mess->what){
		case LEARN_RESULT: // This BMessage is sent by the server only if the client always running.
						   // By this way, client app knows when the learning process is finished
			mess->FindString("LearningResult", &Texte);
			cout << endl << "[LearningResult] = " << Texte << endl;
			break;
		case BRAINBOX_ERR: // This BMessage is sent by the server when an error occured in learning
						   // or running process (if, for example, signature_app BMessage is missing)
			mess->FindString("BraininboxErr", &Texte);
			cout << endl << "[Error] = " << Texte << endl;
			break;
		case THINK_RESULT: // This BMessage is sent by the server when running (thinking) process
						   // is finished.
			double in_value;
			double out_value;
			int32 input_neurons;
			int32 output_neurons;
			int32 count_found_for_in;

			mess->FindInt32("Number_Scheme", &count_found_for_in); // Server returns number of scheme to evaluate
			cout << endl << "[RESULT OF THINKING PROCESS]" << endl;
						
			mess->FindInt32("Input_Neurons", &input_neurons); // Number of input neurons
			mess->FindInt32("Output_Neurons", &output_neurons); // Number of output neurons

			int32 index_in = 0;  // Index BMessage
			int32 index_out = 0;

			for (int32 i = 0; i < count_found_for_in; i++)
			{

			
				cout << "Scheme #" << i+1 << " ";
				for (int32 j = 0; j < input_neurons; j++) // Until read all input values
				{

					mess->FindDouble("YouSend", index_in, &in_value); // Server returns the Scheme to evaluate
					cout << in_value << " ";
					index_in++;
				}
								
				for (int32 j = 0; j < output_neurons; j++)
				{
					mess->FindDouble("IThink", index_out, &out_value); // .. And its result found during running process
					cout << out_value << " ";
					index_out++;
				}
				if (out_value > 0.5) // After retreiving values, you make what you want.
									 // In Xor example, it returns TRUE when the server
									 // gives more than 0.6 (TRUE is the result of 1 xor 0 or
									 // 0 xor 1)
					cout << " " << "<-- TRUE";
				else
					cout << " " << "<-- FALSE";
					
				cout << endl;
			}
			break;
		default:
			BApplication::MessageReceived(mess);
			break;
			
	}

}

void ClientrunApp::ReadyToRun( )
{
	BMessage reply;
	char *Texte;

/*---------------- Thinking Part -----------------------------
	double input_values[2]; // Array of input neurons : 2 neurons for xor function


	BMessenger message = BMessenger("application/x-vnd.QuBernan_Braininabox", -1); // Connect with the Server
	BMessage msg(THINKNOW); // THINKNOW for running process

	
	msg.AddString("signature_app", "application/x-vnd.Braininabox-ClientXor");
	msg.AddInt32("generation", 0); // 0 if you want the last paramters file created by the learning process
								   // This item is optional. By default the server sets to 0 the
								   // file's generation
// First scheme to evaluate
	input_values[0] = 1.0; // Value #1 for xor function
	input_values[1] = 1.0; // Value #2 for xor function
	msg.AddData("input_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values)); // send the array of input values
// Second scheme to evaluate : The server can evaluate several schemes at once
	input_values[0] = 1.0;
	input_values[1] = 0.0;
	msg.AddData("input_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values));

/*---------------end of Thinking Part --------------------------*/

//****************
// Learning Part *
//****************


	double input_values[2]; // Array of input neurons : xor funtion needs two neurons
	double output_values[1]; // Array of output neurons : only one neuron for xor function
	BMessenger message = BMessenger("application/x-vnd.QuBernan_Braininabox", -1); // Connect to the server
	BMessage msg(LESSON); // BMessage for learning process

	msg.AddDouble("learning_rate", 0.4); // Learning_rate. You cand modify this value. Positive value
										  // and under 1. Learning rate is used to compute error
										  // between found ouput and desired output
										  // Here 40%
										  
	msg.AddDouble("momentum_term", 0.8);  // momentum_term adds some noise fighting local minima.
										  // You can modify this value (between 0 and 1).
	
	msg.AddDouble("tolerance", 0.5);	  // tolerance stops the learning process the computed error
										  // is less than this parameter. You can modify this value.
										  // (between 0 and 1).
										  // Here : 50%
	
	msg.AddString("signature_app", "application/x-vnd.Braininabox-ClientXor");
// Gives the number of neurons in each layer
	msg.AddInt32("neurons_in_layer", 2); // First item = number of neurons of INPUT layer
	msg.AddInt32("neurons_in_layer", 3); // middle item = number of neurons of MIDDLE (hidden) layer
										 // You can increase the number of hidden layer adding a new
										 // neurons_in_layer item
	msg.AddInt32("neurons_in_layer", 1); // Last item = number of neuron of OUTPUT layer

// Schemes to evaluate. Each input_values message is a scheme for the input neurons
							// Fist scheme : 0 xor 0
	input_values[0] = 0.0; 
	input_values[1] = 0.0;
	msg.AddData("input_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values));
							// Second scheme : 0 xor 1
	input_values[0] = 0.0;
	input_values[1] = 1.0;
	msg.AddData("input_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values));
							// Third scheme : 1 xor 0
	input_values[0] = 1.0;
	input_values[1] = 0.0;
	msg.AddData("input_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values));
							// Fouth scheme : 1 xor 1
	input_values[0] = 1.0;
	input_values[1] = 1.0;	
	msg.AddData("input_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values));
// Desired output respectively linked to each input scheme
							// First ouput : the result of 0 xor 0 must be 0
	output_values[0] = 0.0;
	msg.AddData("output_values", B_DOUBLE_TYPE, &output_values, sizeof(output_values));
							// First ouput : the result of 0 xor 1 must be 1
	output_values[0] = 1.0;
	msg.AddData("output_values", B_DOUBLE_TYPE, &output_values, sizeof(output_values));
							// First ouput : the result of 1 xor 0 must be 0
	output_values[0] = 1.0;
	msg.AddData("output_values", B_DOUBLE_TYPE, &output_values, sizeof(output_values));
							// First ouput : the result of 1 xor 1 must be 0
	output_values[0] = 0.0;	
	msg.AddData("output_values", B_DOUBLE_TYPE, &output_values, sizeof(output_values));	


	msg.PrintToStream();

//*********************
// End Learning Part  *
//*********************
	
/*----------- Common Code --------------------------------*/
	message.SendMessage(&msg, &reply);
	if (reply.FindString("GetIt", &Texte) != B_OK)
	{
		cout << endl << "[ERROR] Invalid reply " << endl;
	}
	else
	{
		cout << endl << "[GetIt] = " << Texte << endl;
	}

}



